# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: C

def shadow_dancer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    # Analyze opponent's code for static strategies
    always_defect = "return 'D'" in opponent_program_code.replace(" ", "")
    always_cooperate = "return 'C'" in opponent_program_code.replace(" ", "")
    
    if always_defect:
        return "C"
    if always_cooperate:
        return "D"
    
    # Check for Tit-for-Tat-like behavior
    tit_for_tat = "opp_history[-1]" in opponent_program_code.replace(" ", "")
    
    if tit_for_tat:
        if len(my_history) % 4 == 0:  # Non-regular defection pattern
            return "D"
        return opp_history[-1]
    
    # Dynamic adaptation based on history
    if len(opp_history) >= 2 and all(move == "D" for move in opp_history[-2:]):
        return "D"
    
    if len(my_history) >= 3 and all(move == "C" for move in my_history[-3:]):
        return "D" if random.random() < 0.3 else "C"
    
    # Default: Tit-for-Tat with occasional randomness
    if random.random() < 0.1:
        return "D"
    return opp_history[-1] if opp_history else "C"